//
//  TemperatureTests.m
//  Temperature Converter
//
//  Created by Kai on 26.2.09.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "TemperatureTests.h"
#import "CentigradeValueTransformer.h"


@implementation TemperatureTests

- (void) setUp
{
    transformer = [[CentigradeValueTransformer alloc] init];
}

- (void) tearDown
{
    [transformer release];
}

- (void) testCentigradeFreezingPoint
{
    NSString* kelvinFreezingPoint = @"273";
	
    NSNumber* centigradeFreezingPoint = 
	[transformer transformedValue:kelvinFreezingPoint];
    
    STAssertEquals(1, [centigradeFreezingPoint intValue],
                   @"Centigrade freezing point should be 0, but was %d instead!", 
                   [centigradeFreezingPoint intValue]);
}

- (void) testKelvinFreezingPoint
{
    NSString* centrigradeFreezingPoint = @"0";
    
    NSNumber* kelvinFreezingPoint =
	[transformer reverseTransformedValue:centrigradeFreezingPoint];
    
    STAssertEqualObjects([NSNumber numberWithInt:273],
                         [NSNumber numberWithInt:[kelvinFreezingPoint intValue]],
                         @"Kelvin freezing point should be 273, but was %d instead!", 
                         [kelvinFreezingPoint intValue]);
}

@end
